/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.entry;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import xaero.common.category.ui.GuiCategorySettings;
import xaero.common.category.ui.entry.CategorySettingsListEntryWidget;
import xaero.common.graphics.CursorBox;

public abstract class CategorySettingsListEntry
extends GuiComponent {
    protected final int entryRelativeX;
    protected final int entryRelativeY;
    protected final int entryW;
    protected final int entryH;
    protected final int index;
    protected final GuiCategorySettings.SettingRowList rowList;
    protected final List<CategorySettingsListEntry> subEntries;
    protected final Supplier<CursorBox> tooltipSupplier;
    protected int focusedSubEntryIndex;
    protected CategorySettingsListEntry hoveredSubEntry;

    public CategorySettingsListEntry(int entryX, int entryY, int entryW, int entryH, int index, GuiCategorySettings.SettingRowList rowList, Supplier<CursorBox> tooltipSupplier) {
        this.entryRelativeX = entryX;
        this.entryRelativeY = entryY;
        this.entryW = entryW;
        this.entryH = entryH;
        this.index = index;
        this.rowList = rowList;
        this.subEntries = new ArrayList<CategorySettingsListEntry>();
        this.focusedSubEntryIndex = -1;
        this.tooltipSupplier = tooltipSupplier;
    }

    public CategorySettingsListEntry onSelected() {
        if (!this.subEntries.isEmpty() && this.focusedSubEntryIndex >= 0) {
            CategorySettingsListEntry subEntry = this.subEntries.get(this.focusedSubEntryIndex);
            return subEntry.onSelected();
        }
        if (this.selectAction()) {
            if (!(this instanceof CategorySettingsListEntryWidget)) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            }
            this.rowList.updateEntries();
        }
        return this;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public boolean mouseClicked(GuiCategorySettings.SettingRowList.Entry entry, double relativeMouseX, double relativeMouseY, int i) {
        for (int subIndex = 0; subIndex < this.subEntries.size(); ++subIndex) {
            CategorySettingsListEntry subEntry = this.subEntries.get(subIndex);
            double subRelativeMouseX = relativeMouseX - (double)subEntry.entryRelativeX;
            double subRelativeMouseY = relativeMouseY - (double)subEntry.entryRelativeY;
            if (!subEntry.isHoveredOver(relativeMouseX, relativeMouseY)) continue;
            if (this.focusedSubEntryIndex != subIndex) {
                this.unfocusRecursively();
                this.focusedSubEntryIndex = subIndex;
            }
            if (!subEntry.mouseClicked(entry, subRelativeMouseX, subRelativeMouseY, subIndex)) {
                subEntry.confirmSelection();
            }
            return true;
        }
        return false;
    }

    public CategorySettingsListEntry confirmSelection() {
        if (this.focusedSubEntryIndex >= 0) {
            return this.subEntries.get(this.focusedSubEntryIndex).confirmSelection();
        }
        return this.onSelected();
    }

    public boolean mouseReleased(double relativeMouseX, double relativeMouseY, int i) {
        for (CategorySettingsListEntry subEntry : this.subEntries) {
            double subRelativeMouseX = relativeMouseX - (double)subEntry.entryRelativeX;
            double subRelativeMouseY = relativeMouseY - (double)subEntry.entryRelativeY;
            subEntry.mouseReleased(subRelativeMouseX, subRelativeMouseY, i);
        }
        return false;
    }

    public boolean mouseScrolled(double relativeMouseX, double relativeMouseY, double f) {
        for (CategorySettingsListEntry subEntry : this.subEntries) {
            double subRelativeMouseX = relativeMouseX - (double)subEntry.entryRelativeX;
            double subRelativeMouseY = relativeMouseY - (double)subEntry.entryRelativeY;
            if (!subEntry.isHoveredOver(relativeMouseX, relativeMouseY)) continue;
            return subEntry.mouseScrolled(subRelativeMouseX, subRelativeMouseY, f);
        }
        return false;
    }

    public boolean mouseDragged(double relativeMouseX, double relativeMouseY, int i, double f, double g) {
        for (CategorySettingsListEntry subEntry : this.subEntries) {
            double subRelativeMouseX = relativeMouseX - (double)subEntry.entryRelativeX;
            double subRelativeMouseY = relativeMouseY - (double)subEntry.entryRelativeY;
            subEntry.mouseDragged(subRelativeMouseX, subRelativeMouseY, i, f, g);
        }
        return false;
    }

    public void mouseMoved(double relativeMouseX, double relativeMouseY) {
    }

    public boolean keyPressed(int i, int j, int k, boolean isRoot) {
        if (isRoot && (i == 263 && this.moveFocus(-1) || i == 262 && this.moveFocus(1))) {
            return false;
        }
        if (!this.subEntries.isEmpty() && this.focusedSubEntryIndex >= 0) {
            CategorySettingsListEntry subEntry = this.subEntries.get(this.focusedSubEntryIndex);
            return subEntry.keyPressed(i, j, k, false);
        }
        return false;
    }

    public boolean keyReleased(int i, int j, int k) {
        if (!this.subEntries.isEmpty()) {
            for (CategorySettingsListEntry subEntry : this.subEntries) {
                subEntry.keyReleased(i, j, k);
            }
        }
        return false;
    }

    public boolean charTyped(char c, int i) {
        if (!this.subEntries.isEmpty() && this.focusedSubEntryIndex >= 0) {
            CategorySettingsListEntry subEntry = this.subEntries.get(this.focusedSubEntryIndex);
            return subEntry.charTyped(c, i);
        }
        return false;
    }

    public void tick() {
        if (!this.subEntries.isEmpty()) {
            for (CategorySettingsListEntry subEntry : this.subEntries) {
                subEntry.tick();
            }
        }
    }

    public String getSubNarration() {
        if (this.hoveredSubEntry == null) {
            return this.getSelectedNarration();
        }
        return this.getHoveredNarration();
    }

    public String getHoveredNarration() {
        if (this.hoveredSubEntry == null) {
            return this.getHoverNarration();
        }
        return this.hoveredSubEntry.getHoveredNarration();
    }

    public String getSelectedNarration() {
        if (this.focusedSubEntryIndex == -1) {
            return this.getNarration();
        }
        CategorySettingsListEntry subEntry = this.subEntries.get(this.focusedSubEntryIndex);
        return subEntry.getSelectedNarration();
    }

    public Supplier<CursorBox> getTooltipSupplier() {
        return this.tooltipSupplier;
    }

    public abstract String getMessage();

    public String getNarrationMessage() {
        return this.getMessage();
    }

    public String getNarration() {
        CursorBox tooltip;
        StringBuilder narrationBuilder = new StringBuilder();
        narrationBuilder.append(this.getNarrationMessage());
        if (this.tooltipSupplier != null && (tooltip = this.tooltipSupplier.get()) != null) {
            narrationBuilder.append(" . ").append(this.tooltipSupplier.get().getPlainText());
        }
        return narrationBuilder.toString();
    }

    public String getHoverNarration() {
        return this.getNarration();
    }

    public void preRender(PoseStack poseStack, boolean includesSelected, boolean isRoot) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.entryRelativeX, (double)this.entryRelativeY, 0.0);
        if (includesSelected && this.focusedSubEntryIndex == -1) {
            CategorySettingsListEntry.m_93172_((PoseStack)poseStack, (int)0, (int)0, (int)this.entryW, (int)this.entryH, (int)(this.rowList.m_5694_() ? -1 : -8355712));
            CategorySettingsListEntry.m_93172_((PoseStack)poseStack, (int)1, (int)1, (int)(this.entryW - 1), (int)(this.entryH - 1), (int)-16777216);
        }
    }

    public CategorySettingsListEntry render(PoseStack poseStack, int index, int rowWidth, int rowHeight, int relativeMouseX, int relativeMouseY, boolean isMouseOver, float partialTicks, Font font, int globalMouseX, int globalMouseY, boolean includesSelected, boolean isRoot) {
        this.hoveredSubEntry = null;
        CategorySettingsListEntry result = isMouseOver ? this : null;
        for (int i = 0; i < this.subEntries.size(); ++i) {
            CategorySettingsListEntry subEntry = this.subEntries.get(i);
            boolean subIsHovered = subEntry.isHoveredOver(relativeMouseX, relativeMouseY);
            boolean subIncludesSelected = includesSelected && this.focusedSubEntryIndex == i;
            subEntry.preRender(poseStack, subIncludesSelected, false);
            CategorySettingsListEntry subResult = subEntry.render(poseStack, index, rowWidth, rowHeight, relativeMouseX - subEntry.entryRelativeX, relativeMouseY - subEntry.entryRelativeY, subIsHovered, partialTicks, font, globalMouseX, globalMouseY, subIncludesSelected, false);
            subEntry.postRender(poseStack);
            if (!subIsHovered) continue;
            this.hoveredSubEntry = subEntry;
            result = subResult;
        }
        return result;
    }

    public void postRender(PoseStack poseStack) {
        poseStack.m_85849_();
    }

    public boolean isHoveredOver(double relativeMouseX, double relativeMouseY) {
        return relativeMouseX >= (double)this.entryRelativeX && relativeMouseX < (double)(this.entryRelativeX + this.entryW) && relativeMouseY >= (double)this.entryRelativeY && relativeMouseY < (double)(this.entryRelativeY + this.entryH);
    }

    protected abstract boolean selectAction();

    public void changeFocus(boolean bl) {
    }

    public void unhoverRecursively() {
        if (this.hoveredSubEntry != null) {
            this.hoveredSubEntry.unhoverRecursively();
            this.hoveredSubEntry = null;
        }
    }

    public boolean moveFocus(int direction) {
        this.unhoverRecursively();
        if (this.moveFocus(direction, true)) {
            this.rowList.narrateSelection();
            return true;
        }
        return false;
    }

    public boolean moveFocus(int direction, boolean isRoot) {
        if (!this.subEntries.isEmpty()) {
            CategorySettingsListEntry focusedSub = null;
            boolean shouldSwitchLocal = true;
            if (this.focusedSubEntryIndex >= 0) {
                focusedSub = this.subEntries.get(this.focusedSubEntryIndex);
                boolean bl = shouldSwitchLocal = !focusedSub.moveFocus(direction, false);
            }
            if (shouldSwitchLocal) {
                int potentialValue = this.focusedSubEntryIndex + direction;
                if (potentialValue < 0 || potentialValue >= this.subEntries.size()) {
                    if (!isRoot) {
                        return false;
                    }
                    potentialValue = potentialValue < 0 ? this.subEntries.size() - 1 : 0;
                }
                if (this.focusedSubEntryIndex == potentialValue) {
                    return false;
                }
                this.focusedSubEntryIndex = potentialValue;
                focusedSub = this.subEntries.get(this.focusedSubEntryIndex);
                if (direction < 0) {
                    focusedSub.focusLastRecursively();
                } else {
                    focusedSub.focusFirstRecursively();
                }
            }
            return true;
        }
        return false;
    }

    public void unfocusRecursively() {
        this.changeFocus(false);
        if (!this.subEntries.isEmpty()) {
            if (this.focusedSubEntryIndex >= 0) {
                this.subEntries.get(this.focusedSubEntryIndex).unfocusRecursively();
            }
            this.focusedSubEntryIndex = -1;
        }
    }

    public void focusFirstRecursively() {
        this.changeFocus(true);
        if (!this.subEntries.isEmpty()) {
            this.focusedSubEntryIndex = 0;
            this.subEntries.get(this.focusedSubEntryIndex).focusFirstRecursively();
        }
    }

    public void focusLastRecursively() {
        this.changeFocus(true);
        if (!this.subEntries.isEmpty()) {
            this.focusedSubEntryIndex = this.subEntries.size() - 1;
            this.subEntries.get(this.focusedSubEntryIndex).focusLastRecursively();
        }
    }

    public CategorySettingsListEntry withSubEntry(CategorySettingsListEntry entry) {
        this.subEntries.add(entry);
        return this;
    }

    public int getEntryRelativeX() {
        return this.entryRelativeX;
    }

    public int getEntryRelativeY() {
        return this.entryRelativeY;
    }
}

